import sys
import re
import subprocess
import argparse
import html
import requests
import urllib.parse

def handle_search_query(query):
    query = urllib.parse.quote(query)
    ans = requests.get(
        f"https://bandcamp.com/search?q={query}&item_type=a")
    ans.raise_for_status()
    items = re.findall(
        '<div class="heading">.*?</div>',
        ans.text, flags=re.DOTALL
    )
    album_data = []
    max_res = args.max_num_results
    for i,item in enumerate(items):
        if i >= max_res and max_res != 0:
            break
        matches = re.findall(
            '<a href="(.*?)>(.*?)</a>',
            item, flags=re.DOTALL
        )
        title = matches[0][1]
        title = title.strip()
        url = matches[0][0]
        album_data.append({
            'url': url,
            'title': title
        })
    items = re.findall(
        '<div class="subhead">(.*?)</div>',
        ans.text, flags=re.DOTALL
    )
    for i,item in enumerate(items):
        if i >= max_res and max_res != 0:
            break
        artist = item.strip()
        artist = html.unescape(artist)
        artist = artist[3:]
        album_data[i]['artist'] = artist

    return album_data

def search_album(query):
    data = handle_search_query(query)
    for i,item in enumerate(data):
        print(f"{i+1}: {item['title']} by {item['artist']}")
    idx = int(input("Which album? "))
    if idx-1 > len(data):
        print("Out of bounds")
        sys.exit(1)
    print()
    track_selector(data[idx-1]['url'])

def track_selector(url):
    ans = requests.get(url)
    ans.raise_for_status()
    content = ans.text

    tracks = re.findall("trackinfo([^]]*)", content)[0]
    links = re.findall("mp3-128&quot;:&quot;([^}]*)&quot;}", tracks)
    titles = re.findall("&quot;title&quot;:&quot;(.*?)&quot", tracks)
    
    print("0: Whole album")
    for i,_ in enumerate(titles):
        print(f"{i+1}: {titles[i]}")
    
    idx = int(input("Which track? "))
    if idx-1 > len(titles):
        print("Out of bounds")
        sys.exit()
    
    if idx == 0:
        for i,link in enumerate(links):
            print(titles[i])
            subprocess.run(["mpv", link])
    else:
        subprocess.run(["mpv", links[idx-1]])

parser = argparse.ArgumentParser(
    description='Search and play tracks from bandcamp.com')
parser.add_argument(
    "--search-album",
    help="Search for an album"
)
parser.add_argument(
    "--max-num-results",
    type=int,
    default=0,
    help="Restrict number of results shown"
)
args = parser.parse_args()

if args.search_album is None:
    parser.print_help()
    sys.exit()

search_album(args.search_album)
