#!/bin/sh

if [ -d ~/.config/static-sortle/header.gmi ]; then
	cat ~/.config/static-sortle/header.gmi
fi

sortle_repos=$(find -maxdepth 2 -type d | grep "\.sortle" | cut -d/ -f 2)

echo "# My projects\n"

for repo in $sortle_repos; do
    cd $repo 2> /dev/null
	dir="$(pwd | rev | cut -d/ -f 1 | rev)"
	name=$(grep -m1 "^# " readme.md | cut -c 3-) 2> /dev/null
	summary=$(grep -m1 "^# " -A2 readme.md | grep -v "^#" | grep -v ^$) 2> /dev/null
	if [ "$name" = "" ] || [ "$summary" = "" ]; then
    	continue
    fi

	echo "=> $dir $name"
	echo "> $summary\n"
	cd ..
done

if [ -d ~/.config/static-sortle/footer.gmi ]; then
	cat ~/.config/static-sortle/footer.gmi
fi
