#!/bin/sh

cat ~/.config/static-sortle/header.html

sortle_repos=$(find -maxdepth 2 -type d | grep "\.sortle" | cut -d/ -f 2)

for repo in $sortle_repos; do
    cd $repo
	dir="$(pwd | rev | cut -d/ -f 1 | rev)"
	name=$(grep -m1 "^# " readme.md | cut -c 3-)
	summary=$(grep -m1 "^# " -A2 readme.md | grep -v "^#" | grep -v ^$)

	echo "<div class=project-entry>
	<a class=project-name href=\"$dir\">$name</a><br/>
	<p class=project-summary>$summary</p>
</div>"
	cd ..
done

cat ~/.config/static-sortle/footer.html
