#!/bin/sh

# Get temporary versions of files in last saved state
patch_tmp_files () {
    mkdir .sortle/tmp/
    last_commit=$(ls .sortle | grep commit | sort -V | tail -1)
    for file in $(cat .sortle/$last_commit/files | rev | cut -d/ -f1 | rev); do
        cp .sortle/initial/$file .sortle/tmp/
    done
    for commit in $(ls .sortle/ | grep commit_* | sort -V); do
        for patchfile in $(ls .sortle/$commit | grep .diff); do
            fname=$(echo $patchfile | rev | cut -c 6- | rev)
            if [ -f .sortle/tmp/$fname ]; then
        		patch .sortle/tmp/$fname < .sortle/$commit/$patchfile
            fi
        done
    done
}

copy_patched_file () {
    path="$1"
    tmp_path="$2"
	if [ ! "$tmp_path" = "" ]; then
        path="./$tmp_path/$path"
    fi
	# File is not top level
	if [ ! "$(echo $path | cut -d/ -f3)" = "" ]; then
    	mkdir -p "$(echo $path | rev | cut -d/ -f2- | rev)"
   	fi
    cp .sortle/tmp/$(echo $path | rev | cut -d/ -f1 | rev) $path
}

parse_folder () {
	local objs="$1"
	local prefix="$2"
	local level="$3"
	if [ "$level" = "" ]; then
		level=0
	fi
	if [ ! "$prefix" = "" ]; then
    	for i in $(seq 1 $((level-1))); do
        	echo -n "  " >> $dir/index.gmi
        done
    	echo "🗀 $prefix" >> $dir/index.gmi
	fi
	local todo=""
	for obj in $objs; do
		if [ "$(echo $obj | cut -d/ -f3)" = "" ]; then # is regular file
    		file=$(echo $obj | rev | cut -d/ -f1 | rev)
    		fsize=$(ls -lh .sortle/tmp/$file | cut -d" " -f 5)
    		name=$(echo $obj | cut -c 3-)
    		#echo "=> $obj.gmi $name" >> $dir/index.gmi
    		for i in $(seq 1 $level); do
        		echo -n "  " >> $dir/index.gmi
        	done
    		echo "$name" >> $dir/index.gmi
		else
			todo="$todo $obj"
		fi
	done
	while true; do
		if [ "$todo" = "" ]; then
			break
		fi
		obj=$(echo $todo | cut -d" " -f1)
		prefix=$(echo $obj | cut -d/ -f2)
		objs=$(echo $todo | sed 's/ /\n/g' | grep "\.\/$prefix\/" | cut -d/ -f1,3-)
		parse_folder "$objs" "$prefix" "$((level+1))"
		todo=$(echo "$todo" | sed 's/ /\n/g' | grep -v "^\.\/$prefix\/")
	done
}

dir="$(pwd | rev | cut -d/ -f 1 | rev)"
rm -r $dir
mkdir -p $dir

headerpath=~/.config/static-sortle/header.gmi
footerpath=~/.config/static-sortle/footer.gmi

if [ -f $headerpath ]; then
	cat $headerpath >> $dir/index.gmi
	cat $headerpath >> $dir/log.gmi
fi

if [ -f readme.md ]; then
    cat readme.md | sed -e 's/**//g' \
    	-e 's/`\([^`]\+\)`/\1/g' >> $dir/index.gmi
fi

echo "\n=> log.gmi Log" >> $dir/index.gmi
echo "=> files.tar.gz Download repo\n" >> $dir/index.gmi

echo "## Files\n" >> $dir/index.gmi

tar cvf $dir/files.tar .sortle

curr_commit=$(ls .sortle | grep commit | sort -V | tail -1)
patch_tmp_files
files=$(cat .sortle/$curr_commit/files)
for fpath in $files; do
    file=$(echo $fpath | rev | cut -d/ -f1 | rev)
    copy_patched_file $fpath .tmp
    tar rvf $dir/files.tar -C .tmp/ $(echo $fpath | cut -c 3-)
done
parse_folder "$files"
rm -r .tmp
rm -r .sortle/tmp
gzip $dir/files.tar

echo "# Project log\n" > $dir/log.gmi
for f in $(find -type f | grep "\.sortle/commit_.*/info" | sort -Vr); do
    echo $f | cut -d/ -f3 | sed 's/commit_\(.*\)/## Commit \1/' >> $dir/log.gmi
    echo "" >> $dir/log.gmi
    head -n2 $f >> $dir/log.gmi
    echo "" >> $dir/log.gmi
    if [ ! "$(tail +3 $f)" = "" ]; then
    	tail +3 $f | tr "\n" " " >> $dir/log.gmi
    	echo "\n" >> $dir/log.gmi
    fi
done

if [ -f $footerpath ]; then
	cat $footerpath >> $dir/index.gmi
	cat $footerpath >> $dir/log.gmi
fi
