#!/bin/sh

# Get temporary versions of files in last saved state
patch_tmp_files () {
    mkdir .sortle/tmp/
    last_commit=$(ls .sortle | grep commit | sort -V | tail -1)
    for file in $(cat .sortle/$last_commit/files | rev | cut -d/ -f1 | rev); do
        cp .sortle/initial/$file .sortle/tmp/
    done
    for commit in $(ls .sortle/ | grep commit_* | sort -V); do
        for patchfile in $(ls .sortle/$commit | grep .diff); do
            fname=$(echo $patchfile | rev | cut -c 6- | rev)
            if [ -f .sortle/tmp/$fname ]; then
        		patch .sortle/tmp/$fname < .sortle/$commit/$patchfile
            fi
        done
    done
}

copy_patched_file () {
    path="$1"
    tmp_path="$2"
	if [ ! "$tmp_path" = "" ]; then
        path="./$tmp_path/$path"
    fi
	# File is not top level
	if [ ! "$(echo $path | cut -d/ -f3)" = "" ]; then
    	mkdir -p "$(echo $path | rev | cut -d/ -f2- | rev)"
   	fi
    cp .sortle/tmp/$(echo $path | rev | cut -d/ -f1 | rev) $path
}

parse_folder () {
	local objs="$1"
	local prefix="$2"
	local level="$3"
	if [ "$level" = "" ]; then
		level=0
	fi
	if [ ! "$prefix" = "" ]; then
		echo -n "  <tr class=folder>" >> $dir/index.html
		echo -n "    <td class=folder-level-$level>🗀 $prefix</td>" >> $dir/index.html
		echo    "  </tr>" >> $dir/index.html
	fi
	local todo=""
	for obj in $objs; do
		if [ "$(echo $obj | cut -d/ -f3)" = "" ]; then # is regular file
    		file=$(echo $obj | rev | cut -d/ -f1 | rev)
    		fsize=$(ls -lh .sortle/tmp/$file | cut -d" " -f 5)
    		name=$(echo $obj | cut -c 3-)
			echo -n "  <tr class=file>" >> $dir/index.html
			echo -n "    <td class=file-level-$level><a href="$obj.html">$name</a></td>" >> $dir/index.html
			echo -n "    <td class=fsize>$fsize</td>" >> $dir/index.html
			echo    "  </tr>" >> $dir/index.html
		else
			todo="$todo $obj"
		fi
	done
	while true; do
		if [ "$todo" = "" ]; then
			break
		fi
		obj=$(echo $todo | cut -d" " -f1)
		prefix=$(echo $obj | cut -d/ -f2)
		objs=$(echo $todo | sed 's/ /\n/g' | grep "\.\/$prefix\/" | cut -d/ -f1,3-)
		parse_folder "$objs" "$prefix" "$((level+1))"
		todo=$(echo "$todo" | sed 's/ /\n/g' | grep -v "^\.\/$prefix\/")
	done
}

dir="$(pwd | rev | cut -d/ -f 1 | rev)"
rm -r $dir
mkdir -p $dir

headerpath=~/.config/static-sortle/header.html
footerpath=~/.config/static-sortle/footer.html
stylepath=~/.config/static-sortle/stylesheet.css

if [ -f $headerpath ]; then
	cat $headerpath >> $dir/index.html
	cat $headerpath >> $dir/log.html
fi

if [ -f readme.md ]; then
    cat readme.md | md2html --ftables >> $dir/index.html
fi

echo "<p><a href="log.html">Log</a><br>" >> $dir/index.html
echo "<a href="files.tar.gz">Download repo</a></p>" \
  >> $dir/index.html

echo "<h1>Files</h1>" >> $dir/index.html
echo "<table class=filedata>" >> $dir/index.html
echo "<tr> <th class=fheader>Filename</th> <th class=fheader>Size</th> </tr>" >> $dir/index.html

tar cvf $dir/files.tar .sortle

curr_commit=$(ls .sortle | grep commit | sort -V | tail -1)
patch_tmp_files
files=$(cat .sortle/$curr_commit/files)
for fpath in $files; do
    file=$(echo $fpath | rev | cut -d/ -f1 | rev)
    copy_patched_file $fpath .tmp
    echo "<pre><code>" > $dir/$file.html
    cat .sortle/tmp/$file | \
    	sed 's/&/\&amp;/g; s/</\&lt;/g; s/>/\&gt;/g' \
    	>> $dir/$file.html
    echo "</pre></code>" >> $dir/$file.html
    tar rvf $dir/files.tar -C .tmp/ $(echo $fpath | cut -c 3-)
done
parse_folder "$files"
rm -r .tmp
rm -r .sortle/tmp
gzip $dir/files.tar

echo "</table>" >> $dir/index.html

echo "<h1>Project log</h1>\n" >> $dir/log.html
sortle log | \
  sed -e 's/author/**author**/' \
    -e 's/^summary\(.*\)/<br>**summary**\1\n/' \
	-e 's/# commit_\([0-9]*\)/## Commit \1/' | \
  md2html --ftables >> $dir/log.html

if [ -f $footerpath ]; then
	cat $footerpath >> $dir/index.html
	cat $footerpath >> $dir/log.html
fi

if [ -f $stylepath ]; then
    cp $stylepath $dir
fi
