# Sortle Version Control System

Sortle is a tiny vcs written in the dash shell for fun.

## Usage

```
sortle COMMAND [ARG]
```

**Arguments**

| Command | Arg             | Description                                             |
| ------- | --------------- | ------------------------------------------------------- |
| init    | -               | initialize a repository in the current directory        |
| track   | filename        | specify a single file to track                          |
| commit  | -               | save changes from last state in repo                    |
| send    | remote location | send changes to remote repository using scp             |
| pull    | remote location | pull changes from remote repository using scp           |
| diff    | -               | print diffs from last commit to current workspace       |
| log     | -               | print info about every commit in history                |
| revert  | integer         | revert the repository to a previous commit              |
| restore | filename        | restore a tracked file that is deleted in the workspace |

## Implementation

Sortle uses the utilities *diff* and *patch* to track changes
to tracked files.

When first adding a file to the repository using `sortle track`,
the file is copied to `.sortle/initial/`.
Calling `sortle commit` then saves the diffs between the current state
and the last save.
